//-------------------------------------------------------------------------------------
// SID Monitor - Utility for Sudden Ionospheric Disturbances Monitoring Stations
// Copyright (C) 2006-2011 - Lionel Loudet
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//-------------------------------------------------------------------------------------


using System;
using System.Windows.Forms;
using System.Drawing;

namespace SID_monitor.Properties
{
    // This class allows you to handle specific events on the settings class:
    //  The SettingChanging event is raised before a setting's value is changed.
    //  The PropertyChanged event is raised after a setting's value is changed.
    //  The SettingsLoaded event is raised after the setting values are loaded.
    //  The SettingsSaving event is raised before the setting values are saved.
    internal sealed partial class Settings
    {

        public static string[] ChannelColors = new string[16];
        public static string[] ChannelDev1Colors = new string[16];
        public static string[] ChannelDev2Colors = new string[16];
        public static string[] ChannelDev3Colors = new string[16];
        public static string[] ChannelTitles = new string[16];
        public static string[] ChannelStationCodes = new string[16];
        public static string[] ChannelLineWidths = new string[16];
        public static string[] GOESTitles = new string[2];
        public static string[] GOESColors = new string[2];
        public static string[] GOESLineWidths = new string[2];

        public Settings()
        {
            //this.SettingChanging += this.SettingChangingEventHandler;
            this.PropertyChanged += this.PropertyChangedEventHandler;
            // this.SettingsSaving += this.SettingsSavingEventHandler;

            setChannelColors(); // initialisation of ChannelColors
            setGOESColors(); // initialisation of GOESColors
            setChannelStationCodes(); // initialisation of ChannelStationCodes
            setChannelTitles(); // initialisation of ChannelTitles
            setGOESTitles(); // initialisation of GOESTitles
            setChannelLineWidths(); // initialisation of the ChannelLineWidth
            setGOESLineWidths(); // initialisation of the GOESLineWidth
        }

        private void SettingChangingEventHandler(object sender, System.Configuration.SettingChangingEventArgs e)
        {
            // Add code to handle the SettingChanging event here.
        }

        private void SettingsSavingEventHandler(object sender, System.ComponentModel.CancelEventArgs e)
        {
            // Add code to handle the SettingsSaving event here.
        }

        private void PropertyChangedEventHandler(object sender, System.ComponentModel.PropertyChangedEventArgs e)
        {

            // timerADCUpdate, timeGraphUpdate, LabelsADC, LabelsGraph, Minimize to tray menu item
            switch (e.PropertyName)
            {
                case "AcquisitionUpdate":
                    Program.MainForm.timerADCUpdate.Interval = this.AcquisitionUpdate;
                    Program.MainForm.updateLabelsADC();
                    break;
                case "AcquisitionActive":
                    Program.MainForm.timerADCUpdate.Enabled = this.AcquisitionActive;
                    Program.MainForm.updateLabelsADC();
                    break;
                case "GraphUpdate":
                    Program.MainForm.timerGraphUpdate.Interval = this.GraphUpdate;
                    Program.MainForm.updateLabelsGraph();
                    break;
                case "GraphActive":
                    Program.MainForm.timerGraphUpdate.Enabled = this.GraphActive;
                    Program.MainForm.updateLabelsGraph();
                    break;
                case "MinimizeToTray":
                    Program.MainForm.minimizeToTrayToolStripMenuItem.Checked = this.MinimizeToTray;
                    break;
            }


            // toolStripStatusLabelDatabaseLocation
            switch (e.PropertyName)
            {
                case "RRDToolDatabase":
                    Program.MainForm.toolStripStatusLabelDatabaseLocation.Text = "Database: " + this.RRDToolDatabase.ToString();
                    break;
            }

            // checkBoxChannels
            if (Program.MainForm != null)
            {
                switch (e.PropertyName)
                {

                    case "Channel1Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[0].Enabled = this.Channel1Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[0].Checked = this.Channel1Active;
                        break;
                    case "Channel2Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[1].Enabled = this.Channel2Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[1].Checked = this.Channel2Active;
                        break;
                    case "Channel3Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[2].Enabled = this.Channel3Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[2].Checked = this.Channel3Active;
                        break;
                    case "Channel4Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[3].Enabled = this.Channel4Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[3].Checked = this.Channel4Active;
                        break;
                    case "Channel5Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[4].Enabled = this.Channel5Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[4].Checked = this.Channel5Active;
                        break;
                    case "Channel6Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[5].Enabled = this.Channel6Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[5].Checked = this.Channel6Active;
                        break;
                    case "Channel7Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[6].Enabled = this.Channel7Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[6].Checked = this.Channel7Active;
                        break;
                    case "Channel8Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[7].Enabled = this.Channel8Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[7].Checked = this.Channel8Active;
                        break;
                    case "Channel9Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[8].Enabled = this.Channel9Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[8].Checked = this.Channel9Active;
                        break;
                    case "Channel10Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[9].Enabled = this.Channel10Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[9].Checked = this.Channel10Active;
                        break;
                    case "Channel11Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[10].Enabled = this.Channel11Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[10].Checked = this.Channel11Active;
                        break;
                    case "Channel12Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[11].Enabled = this.Channel12Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[11].Checked = this.Channel12Active;
                        break;
                    case "Channel13Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[12].Enabled = this.Channel13Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[12].Checked = this.Channel13Active;
                        break;
                    case "Channel14Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[13].Enabled = this.Channel14Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[13].Checked = this.Channel14Active;
                        break;
                    case "Channel15Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[14].Enabled = this.Channel15Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[14].Checked = this.Channel15Active;
                        break;
                    case "Channel16Active":
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[15].Enabled = this.Channel16Active;
                        Program.MainForm.channelsDockablePanel.CheckBoxChannels[15].Checked = this.Channel16Active;
                        break;
                }
            }


            // ChannelColors
            switch (e.PropertyName)
            {
                case "ShadeValue1":
                case "ShadeValue2":
                case "ShadeValue3":
                case "Channel1LineColor":
                case "Channel2LineColor":
                case "Channel3LineColor":
                case "Channel4LineColor":
                case "Channel5LineColor":
                case "Channel6LineColor":
                case "Channel7LineColor":
                case "Channel8LineColor":
                case "Channel9LineColor":
                case "Channel10LineColor":
                case "Channel11LineColor":
                case "Channel12LineColor":
                case "Channel13LineColor":
                case "Channel14LineColor":
                case "Channel15LineColor":
                case "Channel16LineColor":
                    setChannelColors();
                    break;
            }


            // GOESColors
            switch (e.PropertyName)
            {
                case "PrimaryGOESLineColor":
                case "SecondaryGOESLineColor":
                    setGOESColors();
                    break;
            }


            // ChannelStationCodes
            switch (e.PropertyName)
            {
                case "Channel1StationCode":
                case "Channel2StationCode":
                case "Channel3StationCode":
                case "Channel4StationCode":
                case "Channel5StationCode":
                case "Channel6StationCode":
                case "Channel7StationCode":
                case "Channel8StationCode":
                case "Channel9StationCode":
                case "Channel10StationCode":
                case "Channel11StationCode":
                case "Channel12StationCode":
                case "Channel13StationCode":
                case "Channel14StationCode":
                case "Channel15StationCode":
                case "Channel16StationCode":
                    setChannelStationCodes();
                    break;
            }


            // ChannelTitles
            switch (e.PropertyName)
            {
                case "Channel1Title":
                case "Channel2Title":
                case "Channel3Title":
                case "Channel4Title":
                case "Channel5Title":
                case "Channel6Title":
                case "Channel7Title":
                case "Channel8Title":
                case "Channel9Title":
                case "Channel10Title":
                case "Channel11Title":
                case "Channel12Title":
                case "Channel13Title":
                case "Channel14Title":
                case "Channel15Title":
                case "Channel16Title":
                    setChannelTitles();
                    break;
            }


            // GOESTitles
            switch (e.PropertyName)
            {
                case "PrimaryGOESTitle":
                case "SecondaryGOESTitle":
                    setGOESTitles();
                    break;
            }


            // ChannelLineWidths
            switch (e.PropertyName)
            {
                case "Channel1LineWidth":
                case "Channel2LineWidth":
                case "Channel3LineWidth":
                case "Channel4LineWidth":
                case "Channel5LineWidth":
                case "Channel6LineWidth":
                case "Channel7LineWidth":
                case "Channel8LineWidth":
                case "Channel9LineWidth":
                case "Channel10LineWidth":
                case "Channel11LineWidth":
                case "Channel12LineWidth":
                case "Channel13LineWidth":
                case "Channel14LineWidth":
                case "Channel15LineWidth":
                case "Channel16LineWidth":
                    setChannelLineWidths();
                    break;
            }


            // GOESLineWidths
            switch (e.PropertyName)
            {
                case "PrimaryGOESLineWidth":
                case "SecondaryGOESLineWidth":
                    setGOESLineWidths();
                    break;
            }

        }

        private void setChannelColors()
        {
            ChannelColors[0] = Color.FromArgb(this.Channel1LineColor).Name.Substring(2);
            ChannelColors[1] = Color.FromArgb(this.Channel2LineColor).Name.Substring(2);
            ChannelColors[2] = Color.FromArgb(this.Channel3LineColor).Name.Substring(2);
            ChannelColors[3] = Color.FromArgb(this.Channel4LineColor).Name.Substring(2);
            ChannelColors[4] = Color.FromArgb(this.Channel5LineColor).Name.Substring(2);
            ChannelColors[5] = Color.FromArgb(this.Channel6LineColor).Name.Substring(2);
            ChannelColors[6] = Color.FromArgb(this.Channel7LineColor).Name.Substring(2);
            ChannelColors[7] = Color.FromArgb(this.Channel8LineColor).Name.Substring(2);
            ChannelColors[8] = Color.FromArgb(this.Channel9LineColor).Name.Substring(2);
            ChannelColors[9] = Color.FromArgb(this.Channel10LineColor).Name.Substring(2);
            ChannelColors[10] = Color.FromArgb(this.Channel11LineColor).Name.Substring(2);
            ChannelColors[11] = Color.FromArgb(this.Channel12LineColor).Name.Substring(2);
            ChannelColors[12] = Color.FromArgb(this.Channel13LineColor).Name.Substring(2);
            ChannelColors[13] = Color.FromArgb(this.Channel14LineColor).Name.Substring(2);
            ChannelColors[14] = Color.FromArgb(this.Channel15LineColor).Name.Substring(2);
            ChannelColors[15] = Color.FromArgb(this.Channel16LineColor).Name.Substring(2);

            ChannelDev1Colors[0] = Color.FromArgb(LighterColor(this.Channel1LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[1] = Color.FromArgb(LighterColor(this.Channel2LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[2] = Color.FromArgb(LighterColor(this.Channel3LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[3] = Color.FromArgb(LighterColor(this.Channel4LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[4] = Color.FromArgb(LighterColor(this.Channel5LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[5] = Color.FromArgb(LighterColor(this.Channel6LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[6] = Color.FromArgb(LighterColor(this.Channel7LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[7] = Color.FromArgb(LighterColor(this.Channel8LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[8] = Color.FromArgb(LighterColor(this.Channel9LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[9] = Color.FromArgb(LighterColor(this.Channel10LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[10] = Color.FromArgb(LighterColor(this.Channel11LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[11] = Color.FromArgb(LighterColor(this.Channel12LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[12] = Color.FromArgb(LighterColor(this.Channel13LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[13] = Color.FromArgb(LighterColor(this.Channel14LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[14] = Color.FromArgb(LighterColor(this.Channel15LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);
            ChannelDev1Colors[15] = Color.FromArgb(LighterColor(this.Channel16LineColor, this.ShadeValue1 / 100.0)).Name.Substring(2);

            ChannelDev2Colors[0] = Color.FromArgb(LighterColor(this.Channel1LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[1] = Color.FromArgb(LighterColor(this.Channel2LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[2] = Color.FromArgb(LighterColor(this.Channel3LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[3] = Color.FromArgb(LighterColor(this.Channel4LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[4] = Color.FromArgb(LighterColor(this.Channel5LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[5] = Color.FromArgb(LighterColor(this.Channel6LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[6] = Color.FromArgb(LighterColor(this.Channel7LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[7] = Color.FromArgb(LighterColor(this.Channel8LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[8] = Color.FromArgb(LighterColor(this.Channel9LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[9] = Color.FromArgb(LighterColor(this.Channel10LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[10] = Color.FromArgb(LighterColor(this.Channel11LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[11] = Color.FromArgb(LighterColor(this.Channel12LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[12] = Color.FromArgb(LighterColor(this.Channel13LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[13] = Color.FromArgb(LighterColor(this.Channel14LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[14] = Color.FromArgb(LighterColor(this.Channel15LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);
            ChannelDev2Colors[15] = Color.FromArgb(LighterColor(this.Channel16LineColor, this.ShadeValue2 / 100.0)).Name.Substring(2);

            ChannelDev3Colors[0] = Color.FromArgb(LighterColor(this.Channel1LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[1] = Color.FromArgb(LighterColor(this.Channel2LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[2] = Color.FromArgb(LighterColor(this.Channel3LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[3] = Color.FromArgb(LighterColor(this.Channel4LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[4] = Color.FromArgb(LighterColor(this.Channel5LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[5] = Color.FromArgb(LighterColor(this.Channel6LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[6] = Color.FromArgb(LighterColor(this.Channel7LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[7] = Color.FromArgb(LighterColor(this.Channel8LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[8] = Color.FromArgb(LighterColor(this.Channel9LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[9] = Color.FromArgb(LighterColor(this.Channel10LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[10] = Color.FromArgb(LighterColor(this.Channel11LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[11] = Color.FromArgb(LighterColor(this.Channel12LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[12] = Color.FromArgb(LighterColor(this.Channel13LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[13] = Color.FromArgb(LighterColor(this.Channel14LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[14] = Color.FromArgb(LighterColor(this.Channel15LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
            ChannelDev3Colors[15] = Color.FromArgb(LighterColor(this.Channel16LineColor, this.ShadeValue3 / 100.0)).Name.Substring(2);
        }

        private void setGOESColors()
        {
            GOESColors[0] = Color.FromArgb(this.PrimaryGOESLineColor).Name.Substring(2);
            GOESColors[1] = Color.FromArgb(this.SecondaryGOESLineColor).Name.Substring(2);
        }

        private void setChannelStationCodes()
        {
            ChannelStationCodes[0] = this.Channel1StationCode;
            ChannelStationCodes[1] = this.Channel2StationCode;
            ChannelStationCodes[2] = this.Channel3StationCode;
            ChannelStationCodes[3] = this.Channel4StationCode;
            ChannelStationCodes[4] = this.Channel5StationCode;
            ChannelStationCodes[5] = this.Channel6StationCode;
            ChannelStationCodes[6] = this.Channel7StationCode;
            ChannelStationCodes[7] = this.Channel8StationCode;
            ChannelStationCodes[8] = this.Channel9StationCode;
            ChannelStationCodes[9] = this.Channel10StationCode;
            ChannelStationCodes[10] = this.Channel11StationCode;
            ChannelStationCodes[11] = this.Channel12StationCode;
            ChannelStationCodes[12] = this.Channel13StationCode;
            ChannelStationCodes[13] = this.Channel14StationCode;
            ChannelStationCodes[14] = this.Channel15StationCode;
            ChannelStationCodes[15] = this.Channel16StationCode;
        }

        private void setChannelTitles()
        {
            ChannelTitles[0] = this.Channel1Title;
            ChannelTitles[1] = this.Channel2Title;
            ChannelTitles[2] = this.Channel3Title;
            ChannelTitles[3] = this.Channel4Title;
            ChannelTitles[4] = this.Channel5Title;
            ChannelTitles[5] = this.Channel6Title;
            ChannelTitles[6] = this.Channel7Title;
            ChannelTitles[7] = this.Channel8Title;
            ChannelTitles[8] = this.Channel9Title;
            ChannelTitles[9] = this.Channel10Title;
            ChannelTitles[10] = this.Channel11Title;
            ChannelTitles[11] = this.Channel12Title;
            ChannelTitles[12] = this.Channel13Title;
            ChannelTitles[13] = this.Channel14Title;
            ChannelTitles[14] = this.Channel15Title;
            ChannelTitles[15] = this.Channel16Title;

            if (Program.MainForm != null)
            {
                for (int i = 0; i < ChannelTitles.Length; i++)
                {
                    Program.MainForm.channelsDockablePanel.CheckBoxChannels[i].Text = ChannelTitles[i];
                }
            }
        }

        private void setGOESTitles()
        {
            GOESTitles[0] = this.PrimaryGOESTitle;
            GOESTitles[1] = this.SecondaryGOESTitle;
        }

        private void setChannelLineWidths()
        {
            #region ChannelLineWidths
            // channel 1
            switch (this.Channel1LineWidth)
            {
                case "thin":
                    ChannelLineWidths[0] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[0] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[0] = "1.5";
                    break;
                default:
                    ChannelLineWidths[0] = "0";
                    break;
            }

            // channel 2
            switch (this.Channel2LineWidth)
            {
                case "thin":
                    ChannelLineWidths[1] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[1] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[1] = "1.5";
                    break;
                default:
                    ChannelLineWidths[1] = "0";
                    break;
            }

            // channel 3
            switch (this.Channel3LineWidth)
            {
                case "thin":
                    ChannelLineWidths[2] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[2] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[2] = "1.5";
                    break;
                default:
                    ChannelLineWidths[2] = "0";
                    break;
            }

            // channel 4
            switch (this.Channel4LineWidth)
            {
                case "thin":
                    ChannelLineWidths[3] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[3] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[3] = "1.5";
                    break;
                default:
                    ChannelLineWidths[3] = "0";
                    break;
            }

            // channel 5
            switch (this.Channel5LineWidth)
            {
                case "thin":
                    ChannelLineWidths[4] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[4] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[4] = "1.5";
                    break;
                default:
                    ChannelLineWidths[4] = "0";
                    break;
            }

            // channel 6
            switch (this.Channel6LineWidth)
            {
                case "thin":
                    ChannelLineWidths[5] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[5] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[5] = "1.5";
                    break;
                default:
                    ChannelLineWidths[5] = "0";
                    break;
            }

            // channel 7
            switch (this.Channel7LineWidth)
            {
                case "thin":
                    ChannelLineWidths[6] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[6] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[6] = "1.5";
                    break;
                default:
                    ChannelLineWidths[6] = "0";
                    break;
            }

            // channel 8
            switch (this.Channel8LineWidth)
            {
                case "thin":
                    ChannelLineWidths[7] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[7] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[7] = "1.5";
                    break;
                default:
                    ChannelLineWidths[7] = "0";
                    break;
            }

            // channel 9
            switch (this.Channel9LineWidth)
            {
                case "thin":
                    ChannelLineWidths[8] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[8] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[8] = "1.5";
                    break;
                default:
                    ChannelLineWidths[8] = "0";
                    break;
            }

            // channel 10
            switch (this.Channel10LineWidth)
            {
                case "thin":
                    ChannelLineWidths[9] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[9] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[9] = "1.5";
                    break;
                default:
                    ChannelLineWidths[9] = "0";
                    break;
            }

            // channel 11
            switch (this.Channel11LineWidth)
            {
                case "thin":
                    ChannelLineWidths[10] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[10] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[10] = "1.5";
                    break;
                default:
                    ChannelLineWidths[10] = "0";
                    break;
            }

            // channel 12
            switch (this.Channel12LineWidth)
            {
                case "thin":
                    ChannelLineWidths[11] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[11] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[11] = "1.5";
                    break;
                default:
                    ChannelLineWidths[11] = "0";
                    break;
            }

            // channel 13
            switch (this.Channel13LineWidth)
            {
                case "thin":
                    ChannelLineWidths[12] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[12] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[12] = "1.5";
                    break;
                default:
                    ChannelLineWidths[12] = "0";
                    break;
            }

            // channel 14
            switch (this.Channel14LineWidth)
            {
                case "thin":
                    ChannelLineWidths[13] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[13] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[13] = "1.5";
                    break;
                default:
                    ChannelLineWidths[13] = "0";
                    break;
            }

            // channel 15
            switch (this.Channel15LineWidth)
            {
                case "thin":
                    ChannelLineWidths[14] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[14] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[14] = "1.5";
                    break;
                default:
                    ChannelLineWidths[14] = "0";
                    break;
            }

            // channel 16
            switch (this.Channel16LineWidth)
            {
                case "thin":
                    ChannelLineWidths[15] = "0.5";
                    break;
                case "medium":
                    ChannelLineWidths[15] = "1";
                    break;
                case "thick":
                    ChannelLineWidths[15] = "1.5";
                    break;
                default:
                    ChannelLineWidths[15] = "0";
                    break;
            }
            #endregion
        }

        private void setGOESLineWidths()
        {
            // Primary GOES
            switch (this.PrimaryGOESLineWidth)
            {
                case "thin":
                    GOESLineWidths[0] = "0.5";
                    break;
                case "medium":
                    GOESLineWidths[0] = "1";
                    break;
                case "thick":
                    GOESLineWidths[0] = "1.5";
                    break;
                default:
                    GOESLineWidths[0] = "0";
                    break;
            }
            // Secondary GOES
            switch (this.SecondaryGOESLineWidth)
            {
                case "thin":
                    GOESLineWidths[1] = "0.5";
                    break;
                case "medium":
                    GOESLineWidths[1] = "1";
                    break;
                case "thick":
                    GOESLineWidths[1] = "1.5";
                    break;
                default:
                    GOESLineWidths[1] = "0";
                    break;
            }
        }

        /// <summary>
        /// Creates a lighter color
        /// </summary>
        /// <param name="inColor">the color to lighten</param>
        /// <param name="amout">the amount of lightening between 0 and 1</param>
        /// <returns>the lightened color</returns>
        public int LighterColor(int inputColor, double amount)
        {
            // conversion of the input ARGB color to HSB
            HSBColor inHSBColor = new HSBColor(Color.FromArgb(inputColor));

            // this is where the color is lightened
            HSBColor outHSBColor = new HSBColor(inHSBColor.H,
                                                (1 - amount) * inHSBColor.S,
                                                255*amount + (1 - amount) *inHSBColor.B);

            // conversion of the lightened color to ARBG
            return HSBColor.FromHSB(outHSBColor).ToArgb();
        }
    }
}
